<?php

/*++++++++++++++++++++++++++++++++++++++++

  Script: Maian Gallery v2.0
  Written by: David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: http://www.maianscriptworld.co.uk

  ++++++++++++++++++++++++++++++++++++++++
  
  This File: functions.php
  Description: Admin Functions

  ++++++++++++++++++++++++++++++++++++++++*/
  
// Is webmaster logged in..
function isWebmasterLoggedIn() {
  global $database;
  if (!isset($_SESSION['mgallery_admin_session']) && !isset($_COOKIE[$database['cookieName']])) {
    header("Location: index.php?cmd=login");
    exit;
  } else {
    if (isset($_COOKIE[$database['cookieName']])) {
      if ($_COOKIE[$database['cookieName']]!=encrypt($database['cookieKey'])) {
        header("Location: index.php?cmd=login");
        exit;
      }
    }
  }
}

function encrypt($data) {
  return (function_exists('sha1') ? sha1($data) : md5($data));
} 

// Image attributes/sizes//
function showImgAttributes($id,$folder='',$img='')
{
  global $database,$SETTINGS;
  
  // If id, image is in database..
  if (ctype_digit($id)) {
    if (file_exists(RELATIVE_PATH.'galleries/'.$SETTINGS->folder_name.'/'.$folder.'/'.$img)) {
      $dimensions  = getimagesize(RELATIVE_PATH.'galleries/'.$SETTINGS->folder_name.'/'.$folder.'/'.$img);
      $filesize    = filesize(RELATIVE_PATH.'galleries/'.$SETTINGS->folder_name.'/'.$folder.'/'.$img);
    }
  } else {
    if (file_exists(RELATIVE_PATH.'galleries/new/'.$id)) {
      $dimensions  = getimagesize(RELATIVE_PATH.'galleries/new/'.$id);
      $filesize    = filesize(RELATIVE_PATH.'galleries/new/'.$id);
    }
  }
  
  // Return attributes..
  if (isset($dimensions) && isset($filesize)) {
    return ($folder ? $dimensions[0].' x '.$dimensions[1].' / '.file_size_conversion($filesize,BASE_CONVERSION) : 
            '<div class="attributes">'.
            $dimensions[0].' x '.$dimensions[1].'<br><br><b>'.file_size_conversion($filesize,BASE_CONVERSION).'</b>
            </div>
            ');
  } else {
    return '';
  }
}

// Access Denied..
function accessDenied($txt,$txt2)
{
?>
Access Denied
<?php
exit;
}

// Page numbers..
function admin_page_numbers($count,$limit,$page,$stringVar='page')
{
  global $msg_script9,$msg_script10;

  $PaginateIt = new PaginateIt();
  $PaginateIt->SetCurrentPage($page);
  $PaginateIt->SetItemCount($count);
  $PaginateIt->SetItemsPerPage($limit);
  $PaginateIt->SetLinksToDisplay(50);
  $PaginateIt->SetQueryStringVar($stringVar);
  $PaginateIt->SetLinksFormat('&laquo; '.$msg_script9,
                              ' &bull; ',
                              $msg_script10.' &raquo;'
                              );
                              
  return '<div id="page_numbers">'.$PaginateIt->GetPageLinks().'</div>';                            
}

// Sales count..
function saleTotal($which)
{
  global $database;
  
  $q_total = mysql_query("SELECT SUM($which) AS price FROM ".$database['prefix']."ipndata WHERE activeCart = '1'") or die(mysql_error());
  $TOTAL   = mysql_fetch_object($q_total);
  
  return number_format($TOTAL->price,2);
}

?>
